require( "quest/m3_intersection/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};
flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
		
		actor:SetMode(MODE.CUTSCENE);
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m3_big" then
			actor:JumpToNamedPoint("big");
			actor:FaceNow(DIR.E);
		elseif lastScene == "m3_pancake" then
			actor:JumpToNamedPoint("pancake");
			actor:FaceNow(DIR.W);
		else -- lastScene == m3_gravy
			actor:JumpToNamedPoint("gravy");
			actor:FaceNow(DIR.S);
		end
		
		actor:WalkTo("flo");
		wait_walkto();
		actor:Face(DIR.S);
		actor:SetMode(MODE.FOLLOWCLICKS);
		
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	
		if ( game:Get( "bernie_intro_done" ) ~= 1 ) then
			actor:StartProc( bernie_intro );	
		elseif ( ( game:Get( "bouquets_delivered" ) == 1 ) and ( game:Get( "suspicious_done" ) ~= 1 ) and ( game:Get( "found_bernie" ) ~= 1 ) ) then
			actor:StartProc( suspicious );	
		elseif ( ( game:Get( "found_bernie" ) == 1 ) and ( game:Get( "worried_done" ) ~= 1 ) ) then
			actor:StartProc( worried );		
		end
	end;
	
	on_arrive = function(flo1, flo2)
		convproc("FLO", "quip_flo_general");
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function gotopancake(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("pancake");
	wait_walkto();
	goto_scene(flo, "m3_pancake", true);
end

to_pancake_spec = 
{
	name = "TO_pancake";
	halo = "to_pancake";
	cursor = "cursor_arrow_sw";
	goto_fn = gotopancake;
}

function gotogravy(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("gravy");
	wait_walkto();
	goto_scene(flo, "m3_gravyboat", true);
end

to_gravy_spec = 
{
	name = "TO_GRAVY";
	halo = "to_gravy";
	cursor = "cursor_arrow_e";
	goto_fn = gotogravy;
}

function gotobig(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	flo:WalkTo("big");
	wait_walkto();
	goto_scene(flo, "m3_big", true);
end

to_big_spec = 
{
	name = "TO_BIG";
	halo = "to_big";
	cursor = "cursor_arrow_w";
	goto_fn = gotobig;
}

sign_spec =
{
	name = "SIGN";
	halo = "sign";
	gfx = { image = "sign" };
		
	command = function(actor)
		actor:SetDepthValue( 400 );
		scene:Spawn(sign_text_spec);
	end;
	
	on_arrive = function(flo, sign)
		if ( game:Get( "found_bernie" ) == 1 ) then
			flo:StartProc( worried );
		else
			game:Set( "visited_stand", 1 );
			flo:StartProc( find );
		end
	end;		
}

sign_text_spec = 
{
	name = "SIGN_TEXT";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/franklingothic_demicond.mvec",
			color = { a = 1, r = 1, g = 1, b = 1.0 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 0,
		}
		
		actor:SetAlpha(1);
		
		if ( game:Get( "found_bernie" ) == 1 ) then
			actor:Say("sign_closed");
		else
			actor:Say("sign_lunch");
		end
		
		actor:StopWalking();
		actor:SetPolygon({x=455,y=124}, {x=505,y=124}, {x=455,y=151}, {x=505,y=151});
		actor:TextToImage(10, 10);
	end;
}

evidence2_spec = 
{
	name = "EVIDENCE2";
	gfx = { image = "news_stand_evidence2" };
	
	command = function(actor)
		actor:SetDepthValue(200);
	end
}

evidence3_spec = 
{
	name = "EVIDENCE3";
	gfx = { image = "news_stand_evidence3" };
	
	command = function(actor)
		actor:SetDepthValue(200);
	end
}

bernie_spec = 
{
	name = "BERNIE";
	halo = "quest/objects/bernie";
	gfx = { anim = "anim/bernie/newsstand" };
	
	command = function(actor)
		prepare_actor_text(actor, bernie_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("bernie");
		actor:SetWalkSpeed(bernie_speed);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);
		actor:SetDepthValue( 200 );
		actor:FaceNow(DIR.W);
		actor:ModifySaySpec{ mouth_in_actor = { x = 0, y = -135 } };
	end;
	
	on_arrive = function(flo, bernie)
		flo:StartProc(talk_to_bernie);
	end;
};

function bernie_intro(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.E);
	run_super_conversation(flo, "conv_news_intro");		
	flo:Face(DIR.S);
	game:Set( "bernie_intro_done", 1 );
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function talk_to_bernie(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:Face(DIR.E);
	local numtalks = game:Get( "talk_bernie" );
	local talknum = fmod( numtalks, 3 );
	if talknum == 1 then
		run_super_conversation(flo, "conv_news_bernie_B");
	elseif talknum == 2 then
		run_super_conversation(flo, "conv_news_intro");
	else
		run_super_conversation(flo, "conv_news_bernie_A");
	end
	game:Set( "talk_bernie", numtalks + 1 );	
	flo:Face(DIR.S);
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function find(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_news_find_bernie");
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function worried(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_news_worried");
	game:Set( "worried_done", 1 );	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function suspicious(flo)
	flo:SetMode(MODE.CUTSCENE);
	run_super_conversation(flo, "conv_news_suspicious");
	game:Set( "suspicious_done", 1 );	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

big_ave_sign_spec = 
{
	name = "BIG_AVE_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_big_ave_sign");
		actor:StopWalking();
		actor:SetPolygon({x=291,y=321}, {x=366,y=328}, {x=292,y=335}, {x=367,y=346});
		actor:TextToImage(10, 0);
	end;
}

gravy_boat_way_sign_spec = 
{
	name = "GRAVY_BOAT_WAY_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 20,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_gravy_boat_way_sign");
		actor:StopWalking();
		actor:SetPolygon({x=394,y=328}, {x=516,y=360}, {x=396,y=349}, {x=519,y=378});
		actor:TextToImage(15, 0);
	end;
}

pancake_rd_sign_spec = 
{
	name = "PANCAKE_RD_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_pancake_rd_sign");
		actor:StopWalking();
		actor:SetPolygon({x=309,y=377}, {x=394,y=328}, {x=308,y=400}, {x=392,y=349});
		actor:TextToImage(15, 0);
	end;
}

stop_sign_spec = 
{
	name = "STOP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/helvetica_nevelt_std_blk.mvec",
			color = { a = 1, r = 1, g = 1, b = 1 },
			outline_size = 0,
			lineheight = 30,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_stop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=375,y=363}, {x=429,y=371}, {x=376,y=386}, {x=426,y=393});
		actor:TextToImage(15, 0);
	end;
}

news_stand_sign_spec = 
{
	name = "NEWS_STAND_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/new_century_schlbk_lt_std.mvec",
			color = { a = 1, r = 1, g = 1, b = 0.4 },
			outline_size = 0,
			lineheight = 30,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_news_stand_sign");
		actor:StopWalking();
		actor:SetPolygon({x=308,y=57}, {x=413,y=49}, {x=312,y=77}, {x=413,y=68});
		actor:TextToImage(10, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets3.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		scene:SetRoomScale(300, 550, 0.8, 1.0);	--topline, bottomline, topscale, bottomscale
		
		fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
			--game:Set("bouquets_delivered", 1);
			--game:Set("bernie_intro_done", 1)
		end		
		
		spawn_nav_arrow(to_big_spec);
		spawn_nav_arrow(to_gravy_spec);
		spawn_nav_arrow(to_pancake_spec);
		
		if ( game:Get( "bouquets_delivered" ) == 1 ) then
			scene:Spawn(sign_spec);
			scene:Spawn(evidence2_spec);
			scene:Spawn(evidence3_spec);
		else
			scene:Spawn(bernie_spec);
		end
		
		spawn_simple_hotspot("news_papers", 5);
		
		game:SetString("map_position", "m3_intersection");
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image =
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "loose_magazine", 220 },
		{ "news_stand", 50 },
		{ "foreground", 400 },
		{ "foreground_sign", 500 },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		flo_spec, -- the main actor
		
		big_ave_sign_spec,
		gravy_boat_way_sign_spec,
		pancake_rd_sign_spec,
		stop_sign_spec,
		news_stand_sign_spec,
		scene_setup,
	};
};